import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

const { width } = Dimensions.get("window");

export const bannerStyle = StyleSheet.create({
    skeletonWrapper: {
        width: width,
        height: dpr(156),
        marginBottom: dpr(10),
    },
    indicatorContainer: {
        display: "flex",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "flex-end",
        backgroundColor: "#fff",
        height: dpr(24),
    },
    indicator: {
        height: dpr(8),
        width: dpr(8),
        backgroundColor: "#DFDFDF",
        borderRadius: 50,
        marginHorizontal: 3,
    },
    banner: {
        position: "relative",
    },
    image: {
        width: width - dpr(40),
        height: dpr(156),
        borderRadius: 6,
    },
    content: {
        position: "absolute",
        top: 0,
        left: 0,
        margin: dpr(14),
    },
    title: (color) =>  ({
        fontSize: dpr(13),
        lineHeight: dpr(14),
        fontFamily: "DMSans_400Regular",
        color: color || "#868686"
    }),
    subTitle: (color) => ({
        fontSize: dpr(16),
        fontFamily: "DMSans_700Bold",
        lineHeight: dpr(22),
        marginVertical: dpr(2),
        color: color || "#2C2C2C"
    }),
    description: {
        marginTop: dpr(20),
        marginBottom: dpr(10),
    },
    button: {
        width: dpr(100),
        borderWidth: 1,
        borderColor: "#2C2C2C",
        borderRadius: 2,
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
        paddingVertical: dpr(6),
        paddingHorizontal: dpr(12),
    },
    buttonText: {
        marginRight: 5,
        color: "#2C2C2C",
        fontSize: dpr(13),
        lineHeight: dpr(15),
        fontFamily: "DMSans_700Bold",
    },
    defaultImage: {
        width: width - dpr(20) * 2,
        height: dpr(156),
        borderRadius: 6,
        resizeMode: "cover",
    },
});
